appModule.controller('RootCtrl', ['$rootScope', 'notices', 'api', 'pages', '$translate', 'log', 'utils', function ($rootScope, notices, api, pages, translate, log, utils) {
    //用于客户端广播回调
    window.broadCast = function (type, params) {
        log.logInfo('receive event from main: ' + JSON.stringify(arguments));
        //处理删除的公告板的提示
        if (type == "board_destroy") {
            api.getAccounts(function (data) {
                if (data.length > 0) {
                    notices.openUCAlert(translate.instant("common.account-delete-alert", {name: params.board_name ? params.board_name : translate.instant("common.no-name-account")}), function () {
                    });
                } else {
                    notices.onLastAccountDeleted();
                    notices.openUCAlert(translate.instant("common.account-delete-alert", {name: params.board_name ? params.board_name : translate.instant("common.no-name-account")}), handleNoRightAlert);
                }
                $rootScope.$broadcast(type, params);
            }, function (msg) {
                log.logInfo("get accounts error:" + msg);
            });
            return;
        }else if (type == "board_update") {
            api.getAccounts(function (data) {
                if (data.length > 0) {
                    var index = data.findIndex(function (ac) {
                        return ac.id == params.board_id;
                    });
                    if (index < 0) {
                        notices.openUCAlert(translate.instant("common.no-account-right-alert", {name: params.board_name ? params.board_name : translate.instant("common.no-name-account")}), function () {
                        });
                    }
                    $rootScope.$broadcast(type, params);
                }
            });
            return;
        }else if(type == "app-reconnected"){
            //断线重连后初始化页面
            $rootScope.$broadcast("Init");
        }

        $rootScope.$broadcast(type, params);
    };
    $rootScope.windowName = 'MainWindow';
    $rootScope.lang = appModule.lang;
    pages.attachEventScope($rootScope.windowName, $rootScope);

    $rootScope.convertMsgToHtml = function (msg, callback) {
        var html = utils.convertMsgToHtml(msg);
        callback(html);
    };

    $rootScope.parseCommentCopyData = function(data,callback){
        var html = utils.parseCommentCopyData(data);
        callback(html);
    };

    $rootScope.convertDomStrToMsg = function(html,callback){
        var data = utils.convertDomStrToMsg(html);
        callback(data);
    };

    $rootScope.showFileTransferModule = function () {
        pages.showFileTransferModule();
    };

    //广播鼠标右键菜单
    document.oncontextmenu = function (e) {
        $rootScope.$broadcast("onContextMenu", e);
        return false;
    };

    document.onclick = function (e) {
        $rootScope.$broadcast("onDocumentClick", e);
        return false;
    };

    notices.retrieveLocalData(api.getCurrentUser().userId);

    pages.bindGlobalEvent("openCloudWindow", notices.onOpenCloudWindow);

    var offContextChange = $rootScope.$on('changeContext', function (e, param) {
        log.logInfo('current notice page url:'+location.href);
        var path = location.hash.replace("#", "");
        if (path === param) {
            $rootScope.$broadcast("Init");
            return;
        }
        $(document).find("[ng-view]").children().hide(); //修复切换发布和接收端时，页面闪烁的问题
        location.hash = "#" + param;
        log.logInfo('new notice page url:'+location.href);
    });

    var offLostRight = $rootScope.$on("OnLostPublishRight", function (e) {
        notices.openUCAlert(translate.instant("common.no-right-alert"), handleNoRightAlert);
    });

    $rootScope.$on("$destroy", function () {
        offContextChange();
        offLostRight();
        pages.detachEventScope($rootScope.windowName);
    });

    function handleNoRightAlert() {
        api.notifyCloseError();
        pages.backToConversation();
    }
}]);
